const Sidebar = ({ activeTab, setActiveTab }) => {
  const { TabType } = window;
  
  const tabs = [
    { id: TabType.VUE_GLOBALE, label: 'Suivi global de la cohorte', icon: 'bi-grid-3x3-gap' },
    { id: TabType.PROGRESSION, label: 'Progression', icon: 'bi-graph-up-arrow' },
    { id: TabType.TIMELINE, label: 'Ligne du temps', icon: 'bi-kanban' },
    { id: TabType.HORAIRE, label: 'Horaire mensuel', icon: 'bi-calendar-week' },
    { id: TabType.STAGE, label: 'Planification des stages', icon: 'bi-building' },
    { id: TabType.LOCAUX, label: 'Locaux', icon: 'bi-door-open' },
    { id: TabType.EVALUATIONS, label: 'Modules en cours & évaluations', icon: 'bi-mortarboard' }, 
    { id: TabType.INSCRIPTION, label: 'Gestion des inscriptions', icon: 'bi-pencil-square' },
    { id: TabType.MATRICE, label: 'Matrice', icon: 'bi-table' },
    { id: TabType.CALENDRIER, label: 'Configuration du calendrier', icon: 'bi-calendar3' }, 
  ];

  return (
    <div className="d-flex flex-column flex-shrink-0 p-3 text-white bg-dark h-100 no-print" style={{ width: '260px' }}>
      <ul className="nav nav-pills flex-column mb-auto overflow-auto">
        {tabs.map(tab => (
          <React.Fragment key={tab.id}>
            {tab.id === TabType.INSCRIPTION && <li className="my-2 border-top border-secondary opacity-50"></li>}
            <li className="nav-item mb-1">
              <button
                onClick={() => setActiveTab(tab.id)}
                className={`nav-link w-100 text-start d-flex align-items-center gap-3 ${activeTab === tab.id ? 'active' : 'text-white-50'}`}
                aria-current={activeTab === tab.id ? 'page' : undefined}
              >
                <i className={`bi ${tab.icon} fs-5`}></i>
                <span className="small">{tab.label}</span>
              </button>
            </li>
          </React.Fragment>
        ))}
      </ul>
      <div className="mt-3 pt-3 border-top border-secondary text-center text-light small opacity-75" style={{ fontSize: '0.75rem' }}>
        V2.24
      </div>
    </div>
  );
};

window.Sidebar = Sidebar;