
const Navbar = ({ 
  projectName, 
  setProjectName, 
  tosEmail,
  setTosEmail,
  onNew, 
  onSave, 
  onLoad,
  isDynamic,
  setIsDynamic
}) => {
  const { useRef, useState } = React;
  const fileInputRef = useRef(null);
  const [isSettingsOpen, setIsSettingsOpen] = useState(false);

  const handleFileChange = (e) => {
    if (e.target.files && e.target.files[0]) {
      onLoad(e.target.files[0]);
    }
    if (fileInputRef.current) fileInputRef.current.value = '';
  };

  return (
    <>
      <nav className="navbar navbar-expand-lg navbar-light bg-light border-bottom px-4 py-2 shadow-sm d-flex justify-content-between shrink-0 z-50 d-print-none">
        <div className="d-flex align-items-center gap-3">
          <img 
              src="./logo.png" 
              alt="Logo" 
              style={{ width: '32px', height: '32px', objectFit: 'contain' }} 
              className="rounded-circle"
              onError={(e) => {
                  e.target.style.display = 'none';
                  e.target.nextSibling.style.display = 'flex';
              }}
          />
          <div className="align-items-center justify-content-center bg-primary text-white rounded-circle fw-bold" style={{ width: '32px', height: '32px', display: 'none' }}>FP</div>
          
          <div className="vr h-100 mx-2"></div>
          
          <div className="d-flex flex-column justify-content-center">
              <h1 className="h6 fw-bold text-dark mb-0">{projectName}</h1>
              <span className="text-muted small text-uppercase fw-medium mt-1" style={{ fontSize: '0.7rem' }}>Macroplanification FP</span>
          </div>
          <button 
            onClick={() => setIsSettingsOpen(true)}
            className="btn btn-sm btn-light border ms-2"
            title="Paramètres globaux"
          >
            <i className="bi bi-gear-fill"></i>
          </button>
        </div>

        <div className="d-flex align-items-center gap-3">
          <div className="btn-group btn-group-sm" role="group">
              <button 
                type="button"
                onClick={() => setIsDynamic(false)}
                className={`btn ${!isDynamic ? 'btn-white bg-white text-dark shadow-sm border' : 'btn-light text-muted'}`}
              >
                Statique
              </button>
              <button 
                type="button"
                onClick={() => setIsDynamic(true)}
                className={`btn ${isDynamic ? 'btn-primary shadow-sm' : 'btn-light text-muted'}`}
              >
                Dynamique
              </button>
           </div>

          <div className="d-flex align-items-center gap-2">
              <button 
                  onClick={onNew} 
                  className="btn btn-sm btn-nav-custom d-flex align-items-center gap-2"
                  title="Nouveau projet"
              >
              <i className="bi bi-file-earmark-plus"></i> <span className="d-none d-md-inline">Nouveau</span>
              </button>
              
              <button 
                  onClick={() => fileInputRef.current?.click()} 
                  className="btn btn-sm btn-nav-custom d-flex align-items-center gap-2"
                  title="Ouvrir un projet"
              >
              <i className="bi bi-folder2-open"></i> <span className="d-none d-md-inline">Ouvrir</span>
              </button>
              <input 
              type="file" 
              ref={fileInputRef} 
              onChange={handleFileChange} 
              accept=".json" 
              className="d-none" 
              />

              <button 
                  onClick={onSave} 
                  className="btn btn-sm btn-nav-primary d-flex align-items-center gap-2"
                  title="Sauvegarder"
              >
              <i className="bi bi-floppy"></i> <span className="d-none d-md-inline">Enregistrer</span>
              </button>

              <div className="vr mx-2"></div>

              <button 
                  onClick={() => window.print()} 
                  className="btn btn-sm btn-nav-custom d-flex align-items-center gap-2"
                  title="Imprimer la vue actuelle"
              >
              <i className="bi bi-printer"></i> <span className="d-none d-md-inline">Imprimer</span>
              </button>
          </div>
        </div>
      </nav>

      {isSettingsOpen && (
        <div className="modal show d-block" tabIndex={-1} style={{ backgroundColor: 'rgba(0,0,0,0.5)', zIndex: 1060 }}>
          <div className="modal-dialog modal-dialog-centered">
            <div className="modal-content border-0 shadow-lg">
              <div className="modal-header bg-light">
                <h5 className="modal-title fw-bold h6">Paramètres du programme</h5>
                <button type="button" className="btn-close" onClick={() => setIsSettingsOpen(false)}></button>
              </div>
              <div className="modal-body vstack gap-3">
                <div>
                    <label className="form-label small fw-bold text-secondary text-uppercase">Nom du projet / programme</label>
                    <input 
                        type="text" 
                        value={projectName} 
                        onChange={(e) => setProjectName(e.target.value)} 
                        className="form-control" 
                    />
                </div>
                <div>
                    <label className="form-label small fw-bold text-secondary text-uppercase">Email Global du TOS (Organisation)</label>
                    <input 
                        type="email" 
                        value={tosEmail} 
                        onChange={(e) => setTosEmail(e.target.value)} 
                        className="form-control" 
                        placeholder="technicien@organisation.com"
                    />
                    <div className="form-text small">Cet email sera utilisé par défaut pour toutes les transmissions au service technique.</div>
                </div>
              </div>
              <div className="modal-footer">
                <button type="button" className="btn btn-primary fw-bold px-4" onClick={() => setIsSettingsOpen(false)}>Fermer</button>
              </div>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

window.Navbar = Navbar;
