
const Header = ({ mode, students, selectedStudentName, setSelectedStudentName, activeTab }) => {
  const { TabType } = window;
  
  const hideStudentSelectorTabs = [
    TabType.STAGE,
    TabType.LOCAUX,
    TabType.EVALUATIONS,
    TabType.CALENDRIER,
    TabType.INSCRIPTION
  ];

  const showSelector = !hideStudentSelectorTabs.includes(activeTab);

  return (
    <header className="bg-white border-bottom py-2 px-4 shadow-sm no-print z-1 d-flex align-items-center" style={{ height: '60px' }}>
      {showSelector && (
        <div className="d-flex align-items-center gap-3 flex-grow-1">
          <label className="fw-bold text-secondary text-uppercase small" style={{ letterSpacing: '0.05em' }}>Vue Étudiant :</label>
          <select 
            value={selectedStudentName}
            onChange={(e) => setSelectedStudentName(e.target.value)}
            className="form-select form-select-sm"
            style={{ maxWidth: '300px' }}
          >
            <option value="">-- Vue globale (Cohorte) --</option>
            {students.map(s => (
              <option key={s.name} value={s.name}>{s.name}</option>
            ))}
          </select>
        </div>
      )}
    </header>
  );
};

window.Header = Header;
